﻿/*
PARAMETERS:
	orientation		"horz" "vert"		specifies collision direction
	velocity			contains the impending mnovement along the orientation.		("horz" orientation means velocity is assumed to be xVel)
	hit_mc				collision area movieClip
OPTIONAL PARAMETERS:
	wallId				collision number representing walls		(1)
	map						reference to the map system						(MAP)
	tileSize			size of map tiles											(16)
	
USAGE
	#include "program/collision.as"
	isColliding = getCollision( orientation, velocity, hit_mc, wallId );
	alignHorz( velocity, hit_mc );
	alignVert( velocity, hit_mc );
*/
horzCollision = function( velocity, hit_mc, wallId, map, tileSize )
{
	var output = null;
	var velocity = velocity || 0;
	var wallId = (wallId!=undefined) ? wallId : 1;
	var map = map || MAP;
	var tileSize = tileSize || 16;
	var collision = map.collision_array;
	var area = hit_mc.getBounds(map);
	var margin = 1;
	//
	if(velocity < 0)
		var xx = area.xMin;
	else
		var xx = area.xMax;
	xx += velocity;
	var xTile = Math.floor(xx/tileSize);
	var getCollisionId = function(yy)
	{// getCollisionId()
		var yTile = Math.floor(yy/tileSize);
		return (collision[xTile][yTile] == wallId)
	}// getCollisionId()
	for(var yy=area.yMin+margin; yy<area.yMax-margin; yy+=tileSize )
	{// for:  vertical points along left or right side
		if( getCollisionId(yy) ){
			output = true;
			break;		// stop checking for collision
		}// if:  wall
	}// for:  vertical points along left or right side
	if(!output)
		output = getCollisionId( area.yMax-margin );
	//
	return output;
}// horzCollision()



vertCollision = function( velocity, hit_mc, wallId, map, tileSize )
{
	var output = null;
	var velocity = velocity || 0;
	var wallId = (wallId!=undefined) ? wallId : 1;
	var map = map || MAP;
	var tileSize = tileSize || 16;
	var collision = map.collision_array;
	var area = hit_mc.getBounds(map);
	var margin = 1;
	//
	if(velocity < 0)
		var yy = area.yMin;
	else
		var yy = area.yMax;
	yy += velocity;
	var yTile = Math.floor(yy/tileSize);
	var getCollisionId = function(xx)
	{// getCollisionId()
		var xTile = Math.floor(xx/tileSize);
		return (collision[xTile][yTile] == wallId)
	}// getCollisionId()
	for(var xx=area.xMin+margin; xx<area.xMax-margin; xx+=tileSize )
	{// for:  horizontal points along top or bottom side
		if( getCollisionId(xx) ){
			output = true;
			break;		// stop checking for collision
		}// if:  wall
	}// for:  horizontal points along top or bottom side
	if(!output)
		output = getCollisionId( area.xMax-margin );
	//
	return output;
}// vertCollision()



getCollision = function( orientation, velocity, hit_mc, wallId, map, tileSize )
{
	var output = null;
	orientation = orientation || "horz";
	//
	if(orientation == "horz")
		output = horzCollision(velocity, hit_mc, wallId, map);
	else if(orientation == "vert")
		output = vertCollision(velocity, hit_mc, wallId, map);
	//
	return output;
}// getCollision()



alignHorz = function( velocity, hit_mc, _this, map, tileSize )
{
	var velocity = velocity || 0;
	if(velocity != 0)
	{// if:  moving
		var map = map || MAP;
		var area = hit_mc.getBounds(map);
		var _this = _this || this;
		var tileSize = tileSize || 16;
		
		if(velocity<0)
		{// if:  left
			var xTile = Math.floor((area.xMin +velocity) /tileSize);
			var xNew = (xTile *tileSize) +tileSize;	// right edge of wall tile
			xNew += Math.round((hit_mc._width/2));	// add hitArea
			_this._x = xNew;
		}// if:  left
		else
		{// if:  right
			var xTile = Math.floor((area.xMax +velocity) /tileSize);
			var xNew = xTile *tileSize;	// left edge of wall tile
			xNew -= Math.round((hit_mc._width/2));	// subtract hitArea
			_this._x = xNew;
		}// if:  right
	}// if:  moving
}// alignHorz()



alignVert = function( velocity, hit_mc, _this, map, tileSize )
{
	var velocity = velocity || 0;
	if(velocity != 0)
	{// if:  moving
		var _this = _this || this;
		var map = map || MAP;
		var area = hit_mc.getBounds(map);
		var tileSize = tileSize || 16;
		
		if(velocity<0)
		{// if:  up
			var yTile = Math.floor((area.yMin +velocity) /tileSize);
			var yNew = (yTile *tileSize) +tileSize;	// bottom edge of wall tile
			yNew += hit_mc._height;			// add hitArea
			_this._y = yNew;
		}// if:  up
		else
		{// if:  down
			var yTile = Math.floor((area.yMax +velocity) /tileSize);
			var yNew = (yTile *tileSize);	// top edge of wall tile
	//		yNew -= 0;									// subtract hitArea
			_this._y = yNew;
		}// if:  down
	}// if:  moving
}// alignHorz()